<?php

namespace App\Http\Controllers\Api\V1\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\User\ChangePasswordRequest;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Response;
use Tymon\JWTAuth\Facades\JWTAuth;

class ChangePasswordController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth.jwt');
    }

    /**
     * @param ChangePasswordRequest $request
     * @return mixed
     */
    public function changePassword(ChangePasswordRequest $request)
    {
        $user = User::findOrFail(Auth::id());

        if (!JWTAuth::attempt(['email' => $user->email, 'password' => $request['current_password']])) {
            return Response::clientError(['wrong current password.']);
        }

        $user->update(['password' => $request['new_password']]);

        return Response::success(['password changed successfully.']);
    }
}
