<?php

namespace App\Http\Controllers\Api\V1\Auth;

use App\Http\Constants\UserConstant;
use App\Http\Controllers\Controller;
use App\Http\Requests\Auth\LoginRequest;
use App\Http\Resources\UserResource;
use App\Models\User;
use Illuminate\Support\Facades\Response;
use Symfony\Component\HttpFoundation\Response as Status;
use Tymon\JWTAuth\Facades\JWTAuth;

class LoginController extends Controller
{
    /**
     * @param LoginRequest $request
     * @return mixed
     */
    public function login(LoginRequest $request)
    {
        $credentials = $request->only('email', 'password');

        $user = User::whereEmail($request['email'])->first();

        if (!JWTAuth::attempt($credentials)) {
            return Response::clientError(['Invalid Credentials.'], Status::HTTP_UNAUTHORIZED);
        }

        if ($user['status'] == UserConstant::STATUSES['IN_ACTIVE']) {
            return Response::clientError(['In Active Account'], Status::HTTP_UNAUTHORIZED);
        }

        if ($user['status'] == UserConstant::STATUSES['SUSPENDED']) {
            return Response::clientError(['Suspended Account'], Status::HTTP_UNAUTHORIZED);
        }

        return Response::success([
            'user' => new UserResource($user),
            'token' => $user->generateToken()
        ]);
    }
}
