<?php

namespace App\Http\Controllers\Dashboard\Camp;

use App\Http\Constants\SharedConstant;
use App\Http\Controllers\Controller;
use App\Http\Requests\Camp\CreateRequest;
use App\Http\Requests\Camp\DeleteRequest;
use App\Http\Requests\Camp\UpdateRequest;
use App\Models\Camp;
use App\Models\CampHall;
use App\Models\HallBed;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;

class CampController extends Controller
{
    public function __construct()
    {
        $this->middleware(['role_or_permission:super-admin|create-camps'])->only('store');
        $this->middleware(['role_or_permission:super-admin|show-camps'])->only('show');
        $this->middleware(['role_or_permission:super-admin|update-camps'])->only('update');
        $this->middleware(['role_or_permission:super-admin|list-camps'])->only('list');
        $this->middleware(['role_or_permission:super-admin|delete-camps'])->only('delete');
    }

    /**
     * Display a listing of the resource.
     *
     * @return Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\View\View
     */
    public function index(Request $request)
    {
        $camps = Camp::latest();

        if (isset($request['status']) && !in_array($request['status'], [null, 'all'])) $camps = $camps->where('status', $request['status']);

        if (isset($request['search'])) $camps = $camps->where(function ($query) use ($request) {
            $query->where('name', 'LIKE', "%{$request['search']}%")
                ->orWhere('address', 'LIKE', "%{$request['search']}%");
        });

        $camps = $camps->paginate(SharedConstant::PER_PAGE);

        return view('camps.index', compact('camps'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\View\View
     */
    public function create()
    {
        return view('camps.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(CreateRequest $request)
    {
        Camp::create($request->validated());

        return redirect()->route('camps.index')->with('success', 'تم إضافة المخيم');
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $camp = Camp::findOrFail($id);

        $statuses = SharedConstant::STATUSES;

        return view('camps.show', compact('camp', 'statuses'));
    }


    /**
     * Update the specified resource in storage.
     *
     * @param UpdateRequest $request
     * @param Camp $camp
     * @return RedirectResponse
     */
    public function update(UpdateRequest $request, Camp $camp)
    {
        $camp->update($request->validated());

        return redirect()->route('camps.index')->with('success', 'تم التعديل');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DeleteRequest $request
     * @param int $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy(DeleteRequest $request, int $id)
    {
        Camp::find($id)->delete();

        return redirect()->route('camps.index')->with('success', 'تم الحذف');
    }

    public function fetchHalls(Request $request)
    {
        $data['halls'] = CampHall::whereCampId($request['camp_id'])->whereStatus(SharedConstant::STATUSES['AVAILABLE'])->get();

        return response()->json($data);
    }

    public function fetchCamps(Request $request)
    {
        $data['camps'] = Camp::whereStatus(SharedConstant::STATUSES['AVAILABLE'])->get();
        foreach ($data['camps'] as $camp) {
            $camp->halls;
            foreach ($camp->halls as $hall) {
                $hall->beds;
            }
        }

        return response()->json($data);
    }

    public function fetchBeds(Request $request)
    {
        $data['beds'] = HallBed::whereHallId($request['hall_id'])->whereStatus(SharedConstant::STATUSES['AVAILABLE'])->get();

        return response()->json($data);
    }

}


