<?php

namespace App\Http\Controllers\Dashboard\Rituals;

use App\Http\Controllers\Controller;
use App\Models\Ritual;
use Illuminate\Http\Request;

class RitualsController extends Controller
{
    public function __construct()
    {
        $this->middleware(['role_or_permission:super-admin|create-rituals'])->only('store');
        $this->middleware(['role_or_permission:super-admin|show-rituals'])->only('show');
        $this->middleware(['role_or_permission:super-admin|update-rituals'])->only('update');
        $this->middleware(['role_or_permission:super-admin|list-rituals'])->only('index');
        $this->middleware(['role_or_permission:super-admin|delete-rituals'])->only('delete');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $rituals = Ritual::all();

        return view('rituals.index', compact('rituals'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('rituals.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $ritual = Ritual::create($request->all());

        if ($request->steps) {
            $ritual->steps()->createMany($request->steps);
        }

        return redirect()->route('rituals.index')->with('succss', 'تم الإضافة');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $ritual = Ritual::with(['steps' => function($steps) {
            $steps->orderBy('order');
        }])->findOrFail($id);

        return view('rituals.show', compact('ritual'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $ritual = Ritual::findOrFail($id);

        $ritual->update($request->all());

        if ($request->steps && ($ritual->steps()->select('title', 'order', 'description')->get()->toArray() != ($newSteps = collect($request->steps)->filter(function ($step) {
            return !empty($step['title']);
        })->toArray()))) {
            $ritual->steps()->delete();
            $ritual->steps()->createMany($newSteps);
        }

        return redirect()->route('rituals.index')->with('success', 'تم التعديل');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Ritual::where('id', $id)->delete();

        return redirect()->route('rituals.index')->with('success', 'تم الحذف');
    }
}
