<?php

namespace App\Http\Controllers\Dashboard\Setting;

use App\Http\Controllers\Controller;
use App\Http\Requests\Setting\CreateRequest;
use App\Http\Requests\Setting\UpdateRequest;
use App\Models\Setting;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Http\RedirectResponse;

class SettingController extends Controller
{
    public function __construct()
    {
        $this->middleware(['role_or_permission:super-admin|create-settings'])->only('store');
        $this->middleware(['role_or_permission:super-admin|show-settings'])->only('show');
        $this->middleware(['role_or_permission:super-admin|update-settings'])->only('update');
        $this->middleware(['role_or_permission:super-admin|list-settings'])->only('list');
        $this->middleware(['role_or_permission:super-admin|delete-settings'])->only('delete');
    }

    const PER_PAGE = 15;

    /**
     * Display a listing of the resource.
     *
     * @return Application|Factory|View
     */
    public function index()
    {
        $settings = Setting::latest()->paginate(self::PER_PAGE);

        return view('settings.index', compact('settings'));
    }

    /**
     * Show the form for creating a new resource.
     *
     */
    public function create()
    {
        return view('settings.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param CreateRequest $request
     * @return RedirectResponse
     */
    public function store(CreateRequest $request)
    {
        Setting::create($request->validated());

        return redirect()->route('settings.index')->with('success', 'تم إضافة الإعداد');
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return Application|Factory|\Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $setting = Setting::findOrFail($id);

        return view('settings.show', compact('setting'));
    }


    /**
     * Update the specified resource in storage.
     *
     * @param UpdateRequest $request
     * @param setting $setting
     * @return RedirectResponse
     */
    public function update(UpdateRequest $request, Setting $setting)
    {
        $setting->update($request->validated());

        return redirect()->route('settings.index')->with('success', 'تم التعديل');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return RedirectResponse
     */
    public function destroy(int $id)
    {
        Setting::find($id)->delete();

        return redirect()->route('settings.index')->with('success', 'تم الحذف');
    }
}
