<?php

namespace App\Http\Requests\CampHall;

use App\Http\Constants\SharedConstant;
use App\Models\Camp;
use App\Models\CampHall;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Redirect;

class CreateRequest extends FormRequest
{
    /**
     * override failedValidation method.
     * @param Validator $validator
     * @return RedirectResponse|void
     */
    protected function failedValidation(Validator $validator)
    {
        if ($validator->fails()) {
            $errors = $validator->errors();
            return Redirect::back()->withErrors($errors);
        }
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'name' => 'required|string|min:1|max:100|unique:camp_halls',
            'camp_id' => 'required|integer|exists:camps,id',
            'status' => 'required|integer|in:'
                . SharedConstant::STATUSES['NOT_AVAILABLE']
                . ',' . SharedConstant::STATUSES['AVAILABLE'],
//            'beds_count' => 'required|integer'
        ];
    }

    /**
     * @param \Illuminate\Validation\Validator $validator
     * @return void
     */
    public function withValidator(Validator $validator)
    {
        $errors = [];

        $validator->after(
            function ($validator) use ($errors) {

                //validate case of reach max halls count.
                $max_halls_count = Camp::whereId($this->request->get('camp_id'))->value('halls_count');

                $current_halls_count = CampHall::whereCampId($this->request->get('camp_id'))->count();

                if ($current_halls_count >= $max_halls_count) {
                    $errors[] = 'لقد تخطيت الحد الأقصى لعدد قاعات المخيم ! (' . $max_halls_count . ') مخيم';
                }

                foreach ($errors as $error) {
                    $validator->errors()->add('', $error);
                }
            }
        );

    }
}
