<?php

namespace App\Http\Requests\HallBed;

use App\Http\Constants\SharedConstant;
use App\Models\CampHall;
use App\Models\HallBed;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Redirect;

class CreateRequest extends FormRequest
{
    /**
     * override failedValidation method.
     * @param Validator $validator
     * @return RedirectResponse|void
     */
    protected function failedValidation(Validator $validator)
    {
        if ($validator->fails()) {
            $errors = $validator->errors();
            return Redirect::back()->withErrors($errors);
        }
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'name' => 'required|string|min:1|max:100|unique:camp_halls',
            'camp_id' => 'required|integer|exists:camps,id',
            'hall_id' => 'required|integer|exists:camp_halls,id',
            'status' => 'required|integer|in:'
                . SharedConstant::STATUSES['NOT_AVAILABLE']
                . ',' . SharedConstant::STATUSES['AVAILABLE'],
        ];
    }

    /**
     * @param \Illuminate\Validation\Validator $validator
     * @return void
     */
    public function withValidator(Validator $validator)
    {
        $errors = [];

        $validator->after(
            function ($validator) use ($errors) {

                //validate case of hall doesn't belong to the camp.
                $camp_hall = CampHall::find($this->get('hall_id'));
                $camp_id = $camp_hall->value('camp_id');
                if ($this->get('camp_id') != $camp_id) {
                    $errors[] = 'عفوا هذه القاعة غير موجودة بالمخيم المختار ! ';
                }

                foreach ($errors as $error) {
                    $validator->errors()->add('', $error);
                }
            }
        );

    }
}
