<?php

namespace App\Http\Requests\HallBed;

use App\Http\Constants\SharedConstant;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Redirect;

class UpdateRequest extends FormRequest
{
    /**
     * override failedValidation method.
     * @param Validator $validator
     * @return RedirectResponse|void
     */
    protected function failedValidation(Validator $validator)
    {
        if ($validator->fails()) {
            $errors = $validator->errors();
            return Redirect::back()->withErrors($errors);
        }
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'name' => 'nullable|string|min:1|max:100|unique:hall_beds,name,' . $this->route()->parameter('hall_bed'),
            'camp_id' => 'nullable|integer|exists:camps,id',
            'hall_id' => 'nullable|integer|exists:camp_halls,id',
            'status' => 'nullable|integer|in:'
                . SharedConstant::STATUSES['NOT_AVAILABLE']
                . ',' . SharedConstant::STATUSES['AVAILABLE'],
        ];

    }
}
