<?php

namespace App\Http\Requests\Role;

use App\Models\ModelHasRole;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Redirect;
use Spatie\Permission\Models\Role;

class DeleteRequest extends FormRequest
{
    const SUPER_ADMIN_ID = 1;

    /**
     * override failedValidation method.
     * @param Validator $validator
     * @return RedirectResponse|void
     */
    protected function failedValidation(Validator $validator)
    {
        if ($validator->fails()) {
            $errors = $validator->errors();
            return Redirect::back()->withErrors($errors);
        }
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            //
        ];
    }

    /**
     * @param \Illuminate\Validation\Validator $validator
     * @return void
     */
    public function withValidator(Validator $validator)
    {
        $errors = [];

        $validator->after(
            function ($validator) use ($errors) {

                //validate case of role has been assigned to a model.
                Role::findOrFail($this->route()->parameter('role'));

                $used_by_model_count = ModelHasRole::whereRoleId($this->route()->parameter('role'))->count();

                if ($used_by_model_count > 0) {
                    $errors[] = 'لا يمكن حذف مجموعة مستخدمة بداخل النظام';
                }

                //validate case of role is not super admin.
                if ($this->route()->parameter('role') == self::SUPER_ADMIN_ID) {
                    $errors[] = 'لا يمكن حذف مجموعة السوبر أدمن';

                }

                foreach ($errors as $error) {
                    $validator->errors()->add('', $error);
                }
            }
        );

    }
}
