<?php

namespace App\Http\Requests\User;

use App\Http\Constants\UserConstant;
use App\Models\User;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redirect;

class   ShowRequest extends FormRequest
{
    /**
     * override failedValidation method.
     * @param Validator $validator
     * @return RedirectResponse|void
     */
    protected function failedValidation(Validator $validator)
    {
        if ($validator->fails()) {
            $errors = $validator->errors();
            return Redirect::back()->withErrors($errors);
        }
    }
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        dd(Auth::user());
        $user = User::findOrFail($this->route('user'));

        // supervisor can only show his profile and pilgrim profiles.
//        if (Auth::user()->type == UserConstant::TYPES['SUPERVISOR']) {
//
//            if ($user->id != Auth::id() && $user->type == UserConstant::TYPES['SUPERVISOR']) {
//                return false;
//            }
//
//            if ($user->id != Auth::id() && $user->type != UserConstant::TYPES['PILGRIM']) {
//                return false;
//            }
//        }

        // pilgrim can only show his profile.
        if (Auth::user()->type == UserConstant::TYPES['PILGRIM']) {
            if ($user->id != Auth::id())
                return false;
        }

        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            //
        ];
    }
}
