<?php

namespace App\Http\Requests\User;

use App\Http\Constants\UserConstant;
use App\Models\User;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redirect;

class UpdateRequest extends FormRequest
{
    /**
     * override failedValidation method.
     * @param Validator $validator
     * @return RedirectResponse|void
     */
    protected function failedValidation(Validator $validator)
    {
        if ($validator->fails()) {
            $errors = $validator->errors();
            return Redirect::back()->withErrors($errors);
        }
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        /**
         * supervisor can only update a pilgrim.
         * pilgrim can not update any except him self.
         */

        if (Auth::user()->type == UserConstant::TYPES['SUPERVISOR']) {

            $user = User::findOrFail($this->route()->parameter('user')->id);
//dd($user->id,Auth::id());
            if ($user->type != UserConstant::TYPES['PILGRIM'] && $user->id != Auth::id())

                return false;

        } else if (Auth::user()->type == UserConstant::TYPES['PILGRIM']) {

            return false;
        }
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'first_name' => 'nullable|string|min:3|max:100',
            'last_name' => 'nullable|string|min:3|max:100',
            'email' => 'nullable|string|email|max:100|unique:users,email,' . $this->route()->parameter('user')->id,
            'phone' => 'nullable|string|min:3|max:100|unique:users,phone,' . $this->route()->parameter('user')->id,
            'status' => 'nullable|in:'
                . UserConstant::STATUSES['IN_ACTIVE']
                . ',' . UserConstant::STATUSES['ACTIVE']
                . ',' . UserConstant::STATUSES['SUSPENDED'],
            'password' => 'nullable|string|min:8|max:100|confirmed',
            'role_id' => 'nullable|integer',
            'extra_permissions_ids' => 'nullable|array',
            'extra_permissions_ids.*' => 'integer'
        ];
    }
}
