<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;

class PermissionTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // reset cached roles and permissions
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        $modules = include(resource_path('permissions.php'));

        foreach ($modules as $module => $module_ar) {
            foreach ([
                'create',
                'update',
                'delete',
                'list',
                'show'
            ] as $action) {
                Permission::create(['name' => $action . '-' . $module] + compact('module', 'module_ar'));
            }
        }
    }
}
