<?php

namespace Database\Seeders;

use App\Http\Constants\UserConstant;
use App\Models\User;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class UsersTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */


    public function run()
    {
        /**
         * Create User.
         */
        $user = User::create([
            'first_name' => 'super',
            'last_name' => 'admin',
            'email' => 'super@admin.com',
            'phone' => '+966123456789',
            'type' => UserConstant::TYPES['ADMIN'],
            'status' => UserConstant::STATUSES['ACTIVE'],
            'password' => '12345678',
        ]);

        // reset cached roles and permissions
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        /**
         * Create Super Admin Role.
         */
        $role = Role::create(['name' => 'super-admin', 'name_ar' => 'مدير']);

        $permissions = Permission::pluck('id');

        /**
         * Assign Permission to Role.
         */
        $role->syncPermissions($permissions);

        $user->assignRole($role);

        //create another role
        Role::create(['name' => 'supervisor', 'name_ar' => 'مشرف'])->syncPermissions($permissions->random(5));
    }
}
