@extends('layouts.main')


@section('content')
    <!--begin::Content wrapper-->
    <div class="d-flex flex-column flex-column-fluid">

        <!--begin::Toolbar-->
        <div id="kt_app_toolbar" class="app-toolbar py-3 py-lg-6">
            <!--begin::Toolbar container-->
            <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex flex-stack"
                 style="justify-content: start">
                <!--begin::Page title-->
                <div class="page-title d-flex flex-column justify-content-center flex-wrap me-3">
                    <!--begin::Title-->
                    <h1 class="page-heading d-flex text-dark fw-bold fs-3 flex-column justify-content-center my-0">
                        المستخدمين</h1>
                    <!--end::Title-->
                    <!--begin::Breadcrumb-->
                    <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0 pt-1">
                        <!--begin::Item-->
                        <li class="breadcrumb-item text-muted">
                            <a href="{{ route('home') }}" class="text-muted text-hover-primary">الرئيسية</a>
                        </li>
                        <!--end::Item-->
                        <!--begin::Item-->
                        <li class="breadcrumb-item">
                            <span class="bullet bg-gray-400 w-5px h-2px"></span>
                        </li>
                        <!--end::Item-->
                        <!--begin::Item-->
                        <li class="breadcrumb-item text-muted">المستخدمين</li>
                        <!--end::Item-->
                    </ul>
                    <!--end::Breadcrumb-->

                </div>
                <a style="margin-right: 35px;" href="{{ route('users.data') }}"
                   class="btn btn-primary btn-sm align-self-center">ادراج / استخراج
                    قائمة الحجاج</a>
                </a>
                <!--end::Page title-->
            </div>
            <!--end::Toolbar container-->
        </div>
        <!--end::Toolbar-->

        <!--begin::Content-->
        <div id="kt_app_content" class="app-content flex-column-fluid">
            <!--begin::Content container-->
            <div id="kt_app_content_container" class="app-container container-xxl">
                @include('layouts.partials.alerts')
                <div class="card mb-5 mb-xl-8">
                    <!--begin::Header-->
                    <div class="card-header border-0 pt-5">
                        <h3 class="card-title align-items-start flex-column" style="display: block;">
                            <a href="{{ route('users.index') }}"> <span
                                    class="card-label fw-bold fs-3 mb-1">المستخدمين</span></a> |
                            {{-- <span class="text-muted mt-1 fw-semibold fs-7">Over 500 new products</span>--}}
                            <a href="{{ route('users.create') }}" class="btn btn-sm btn-light-primary">
                                <!--begin::Svg Icon | path: icons/duotune/arrows/arr075.svg-->
                                <span class="svg-icon svg-icon-2">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <rect opacity="0.5" x="11.364" y="20.364" width="16" height="2" rx="1"
                                          transform="rotate(-90 11.364 20.364)" fill="currentColor"/>
                                    <rect x="4.36396" y="11.364" width="16" height="2" rx="1" fill="currentColor"/>
                                </svg>
                            </span>
                                <!--end::Svg Icon-->مستخدم جديد
                            </a>
                        </h3>
                        <div class="card-toolbar">
                            <!--begin::Actions-->
                            <div class="d-flex align-items-center gap-2 gap-lg-3">
                                <!--begin::Filter menu-->
                                <div class="m-0">
                                    <!--begin::Menu toggle-->
                                    <a href="#"
                                       class="btn btn-sm btn-flex bg-body btn-color-gray-700 btn-active-color-primary fw-bold"
                                       data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end">
                                        <!--begin::Svg Icon | path: icons/duotune/general/gen031.svg-->
                                        <span class="svg-icon svg-icon-6 svg-icon-muted me-1">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M19.0759 3H4.72777C3.95892 3 3.47768 3.83148 3.86067 4.49814L8.56967 12.6949C9.17923 13.7559 9.5 14.9582 9.5 16.1819V19.5072C9.5 20.2189 10.2223 20.7028 10.8805 20.432L13.8805 19.1977C14.2553 19.0435 14.5 18.6783 14.5 18.273V13.8372C14.5 12.8089 14.8171 11.8056 15.408 10.964L19.8943 4.57465C20.3596 3.912 19.8856 3 19.0759 3Z"
                                                fill="currentColor"/>
                                        </svg>
                                    </span>
                                        <!--end::Svg Icon-->تحديد خيارات العرض</a>
                                    <!--end::Menu toggle-->

                                    <!--begin::Menu 1-->
                                    <div class="menu menu-sub menu-sub-dropdown w-250px w-md-300px" data-kt-menu="true"
                                         id="kt_menu_631f0552f045e">
                                        <!--begin::Header-->
                                        <div class="px-7 py-5">
                                            <div class="fs-5 text-dark fw-bold">خيارات العرض</div>
                                        </div>

                                        {!! Form::open(['url' => route('users.index') ,'class' => 'form', 'method' => 'GET']) !!}

                                        <!--end::Header-->
                                        <!--begin::Menu separator-->
                                        <div class="separator border-gray-200"></div>
                                        <!--end::Menu separator-->
                                        <!--begin::Form-->
                                        <div class="px-7 py-5">
                                            <!--begin::Input group-->
                                            <div class="mb-10">
                                                <!--begin::Label-->
                                                <label class="form-label fw-semibold">الحالة:</label>
                                                <!--end::Label-->
                                                <!--begin::Input-->
                                                <div>
                                                    <select class="form-select form-select-solid" data-kt-select2="true"
                                                            name="status" data-placeholder="اختر"
                                                            data-dropdown-parent="#kt_menu_631f0552f045e"
                                                            data-allow-clear="true">
                                                        <option></option>
                                                        <option value="all">الكل</option>
                                                        <option value="1">نشط</option>
                                                        <option value="0">غير نشط</option>
                                                        <option value="2">موقوف</option>
                                                    </select>
                                                </div>
                                                <!--end::Input-->
                                                <!--begin::Input group-->
                                                <div class="mb-10">
                                                    <!--begin::Label-->
                                                    <label class="form-label fw-semibold">نوع المستخدم:</label>
                                                    <!--end::Label-->
                                                    <!--begin::Input-->
                                                    <div>
                                                        <select class="form-select form-select-solid" name="type"
                                                                data-kt-select2="true" data-placeholder="اختر"
                                                                data-dropdown-parent="#kt_menu_631f0552f045e"
                                                                data-allow-clear="true">
                                                            <option></option>
                                                            <option value="all">الكل</option>
                                                            <option value="2">أدمن</option>
                                                            <option value="1">مشرف</option>
                                                            <option value="0">حاج</option>
                                                        </select>
                                                    </div>
                                                    <!--end::Input-->

                                                </div>
                                                <!--end::Input group-->
                                                <!--begin::Actions-->
                                                <div class="d-flex justify-content-end">
                                                    <a href="{{route('users.index')}}">
                                                        <button type="reset"
                                                                class="btn btn-sm btn-light btn-active-light-primary me-2"
                                                                data-kt-menu-dismiss="true">إلغاء
                                                        </button>
                                                    </a>
                                                    <button type="submit" class="btn btn-sm btn-primary"
                                                            data-kt-menu-dismiss="true">عرض البيانات
                                                    </button>
                                                    {!! Form::close() !!}

                                                </div>
                                                <!--end::Actions-->
                                            </div>
                                            <!--end::Form-->
                                        </div>
                                        <!--end::Menu 1-->
                                    </div>

                                    <!--end::Menu 1-->
                                </div>
                                <!--end::Actions-->
                            </div>
                            <!--begin::Search-->
                            {!! Form::open(['url' => route('users.index') ,'class' => 'form', 'method' => 'GET']) !!}
                            <div class="d-flex align-items-center position-relative my-1">
                                <!--begin::Svg Icon | path: icons/duotune/general/gen021.svg-->
                                <span class="svg-icon svg-icon-1 position-absolute ms-6">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <rect opacity="0.5" x="17.0365" y="15.1223" width="8.15546" height="2" rx="1"
                                          transform="rotate(45 17.0365 15.1223)" fill="currentColor"/>
                                    <path
                                        d="M11 19C6.55556 19 3 15.4444 3 11C3 6.55556 6.55556 3 11 3C15.4444 3 19 6.55556 19 11C19 15.4444 15.4444 19 11 19ZM11 5C7.53333 5 5 7.53333 5 11C5 14.4667 7.53333 17 11 17C14.4667 17 17 14.4667 17 11C17 7.53333 14.4667 5 11 5Z"
                                        fill="currentColor"/>
                                </svg>
                            </span>
                                <!--end::Svg Icon-->
                                <input type="text" name="search" data-kt-customer-table-filter="search"
                                       class="form-control form-control-solid w-250px ps-15"
                                       placeholder="اسم المستخدم"/>
                            </div>
                            {!! Form::close() !!}

                            <!--end::Search-->
                        </div>
                        <!--end::Header-->
                        <!--begin::Body-->
                        <div class="card-body py-3">
                            <!--begin::Table container-->
                            <div class="table-responsive">
                                <!--begin::Table-->
                                <table id="users-table" class="table align-middle gs-0 gy-4">
                                    <!--begin::Table head-->
                                    <thead>
                                    <tr class="fw-bold text-muted bg-light">
                                        <th class="ps-4 min-w-200px rounded-start">الإسم</th>
                                        <th class="min-w-125px">البريد الإلكتروني</th>
                                        <th class="min-w-125px">رقم الهاتف</th>
                                        <th class="min-w-125px">الأوامر</th>
                                        <th class="min-w-2000px text-end rounded-end"></th>
                                    </tr>
                                    </thead>
                                    <!--end::Table head-->
                                    <!--begin::Table body-->
                                    <tbody>
                                    @foreach($users as $user)
                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="symbol symbol-50px me-5">
                                                        {{-- <img src="assets/media/stock/600x400/img-26.jpg" class="" alt=""/>--}}
                                                    </div>
                                                    <div class="d-flex justify-content-start flex-column">
                                                        <a href="#"
                                                           class="text-dark fw-bold text-hover-primary mb-1 fs-6">{{$user->first_name.' ' .$user->last_name}}</a>
                                                        {{-- <span class="text-muted fw-semibold text-muted d-block fs-7">HTML, JS, ReactJS</span>--}}
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <a href="#"
                                                   class="text-dark fw-bold text-hover-primary d-block mb-1 fs-6">{{$user->email}}</a>
                                            </td>
                                            <td>
                                                <a href="#"
                                                   class="text-dark fw-bold text-hover-primary d-block mb-1 fs-6">{{$user->phone}}</a>
                                            </td>
                                            </a>
                                            <td class="text-end" style="display: flex;justify-content: right;">
                                                <a href="{{ route('users.show',$user->id ) }}"
                                                   class="btn btn-primary btn-sm align-self-center">عرض</a>

                                                {!! Form::open(['url' => route('users.destroy', $user->id), 'method' => 'DELETE', 'class' => 'd-inline']) !!}
                                                <button style="margin-right: 5px" type="submit"
                                                        onclick="return confirm('هل أنت متأكد من الحذف ؟')"
                                                        class="btn btn-danger btn-sm align-self-center">حذف
                                                </button>

                                                {!! Form::close() !!}

                                            </td>

                                        </tr>
                                    @endforeach
                                    </tbody>
                                    <!--end::Table body-->
                                </table>
                                <!--end::Table-->
                                <!--begin::Pagination-->
                                <div class="d-flex flex-stack flex-wrap pt-10">
                                    <div class="fs-6 fw-semibold text-gray-700">Showing {{$users->count()}}
                                        of {{ $users->total() }} Entries
                                    </div>
                                    <!--begin::Pages-->
                                    {{ $users->links() }}
                                    <!--end::Pages-->
                                </div>
                                <!--end::Pagination-->
                            </div>
                            <!--end::Table container-->
                        </div>
                        <!--begin::Body-->
                    </div>

                    <!--end::Header---->
                    <!--begin::Actions-->
                    <div class="d-flex align-items-center gap-2 gap-lg-3">

                    </div>
                    <!--end::Actions-->
                </div>
                <!--end::Content container-->
            </div>
        </div>
        <!--end::Content-->

    </div>
    <!--end::Content wrapper-->
@endsection
