<?php

use App\Http\Controllers\Dashboard\Camp\CampController;
use App\Http\Controllers\Dashboard\HallBed\HallBedController;
use App\Http\Controllers\Dashboard\CampHall\CampHallController;
use App\Http\Controllers\Dashboard\DashboardController;
use App\Http\Controllers\Dashboard\Housing\HousingController;
use App\Http\Controllers\Dashboard\Rituals\RitualsController;
use App\Http\Controllers\Dashboard\Location\LocationController;
use App\Http\Controllers\Dashboard\Google\GoogleController;
use App\Http\Controllers\Dashboard\Role\RoleController;
use App\Http\Controllers\Dashboard\Setting\SettingController;
use App\Http\Controllers\Dashboard\User\UserController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
//TODO:Restrict Who's can Login to Dashboard.

Route::group(['middleware' => ['auth']], function () {

    Route::get('/', [DashboardController::class, 'index'])->name('home');

    /**
     * Models Resources.
     */
    Route::resource('roles', RoleController::class);
    Route::resource('users', UserController::class);
    Route::resource('rituals', RitualsController::class);
    Route::resource('camps', CampController::class);
    Route::resource('camp-halls', CampHallController::class);
    Route::resource('hall-beds', HallBedController::class);
    Route::resource('locations', LocationController::class);
    Route::resource('settings', SettingController::class);


    /**
     * Housings
     */
    Route::resource('user-housings', HousingController::class);
    Route::get('fetch-pilgrim-data/{pilgrim_id}', [UserController::class, 'fetchPilgrimData']);
    Route::post('fetch-camps', [CampController::class, 'fetchCamps']);
    Route::post('fetch-camp-halls', [CampController::class, 'fetchHalls']);
    Route::post('fetch-hall-beds', [CampController::class, 'fetchBeds']);
    Route::post('user-housings-assign', [HousingController::class, 'assignUser'])->name('housing.assign');
    Route::post('user-housings-reset', [HousingController::class, 'resetHousings'])->name('housing.reset');
    Route::post('user-housings-un-assign', [HousingController::class, 'unAssignUser'])->name('housing.un-assign');


    /**
     * Pilgrims Import/Export.
     */
    Route::get('users-data', [UserController::class, 'usersData'])->name('users.data');
    Route::post('users-export', [UserController::class, 'export'])->name('users.export');
    Route::post('users-import', [UserController::class, 'import'])->name('users.import');;

    /**
     * Google Maps.
     */
    Route::get('google-autocomplete', [GoogleController::class, 'index']);

});

require __DIR__ . '/auth.php';
