<?php

namespace App\Exports;

use App\Http\Constants\UserConstant;
use App\Models\User;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class UsersExport implements FromCollection, WithHeadings
{
    protected $year;

    function __construct($year)
    {
        $this->year = $year;
    }


    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        return User::select("id", "first_name", "last_name", "email", "phone")
            ->where('type', UserConstant::TYPES['PILGRIM'])
            ->whereYear('created_at', '=', $this->year)
            ->get();
    }

    /**
     * Write code on Method
     *
     */
    public function headings(): array
    {
        return ["Id", "First Name", "Last Name", "Email", "Phone"];
    }
}
