<?php

namespace App\Http\Controllers\Api\V1\User;

use App\Exports\UsersExport;
use App\Http\Constants\UserConstant;
use App\Http\Controllers\Controller;
use App\Http\Requests\User\ShowRequest;
use App\Http\Requests\User\AssignRequest;
use App\Http\Requests\User\CreateRequest;
use App\Http\Resources\UserResource;
use App\Imports\UsersImport;
use App\Models\User;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Maatwebsite\Excel\Facades\Excel;
use Maatwebsite\Excel\Validators\ValidationException;
use Spatie\MediaLibrary\MediaCollections\Exceptions\FileDoesNotExist;
use Spatie\MediaLibrary\MediaCollections\Exceptions\FileIsTooBig;
use Spatie\Permission\Models\Role;


class UserController extends Controller
{
    public function __construct()
    {
//        $this->middleware(['role_or_permission:super-admin|user-show'])->only('show');
        $this->middleware(['role_or_permission:super-admin|user-update'])->only('update');
        $this->middleware(['role_or_permission:super-admin|user-list'])->only('list');
        $this->middleware(['role_or_permission:super-admin|user-export'])->only('export');
        $this->middleware(['role_or_permission:super-admin|user-import'])->only('import');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
//    public function index(Request $request)
//    {
//        $users = User::latest();
//
//        if (isset($request['status'])) $users = $users->where('status', $request['status']);
//
//        if (isset($request['type'])) $users = $users->where('type', $request['type']);
//
//        if (isset($request['search'])) $users = $users->where(function ($query) use ($request) {
//            $query->where('first_name', 'LIKE', "%{$request['search']}%")
//                ->orWhere('last_name', 'LIKE', "%{$request['search']}%");
//        });
//
//        $users = $users->paginate(UserConstant::PER_PAGE);
//
//        return Response::success(UserResource::collection($users)->response()->getData());
//    }


    /**
     * Display the specified resource.
     *
     * @param ShowRequest $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show(ShowRequest $request, int $id)
    {
        dd($request->header());
        $user = User::findOrFail($id);

        return Response::success(new UserResource($user));
    }

//    /**
//     * Update the specified resource in storage.
//     *
//     * @param UpdateRequest $request
//     * @param User $user
//     * @return \Illuminate\Http\Response
//     * @throws FileDoesNotExist
//     * @throws FileIsTooBig
//     */
//    public function update(UpdateRequest $request, User $user)
//    {
//        $user->update($request->validated());
//
//        //sync photo.
//        if ($request['photo']) {
//            $this->syncPhoto($user);
//        }
//
//        //revoke old roles and permissions.
//        $this->revokeOldRolesAndPermissions($user);
//
//        //Assign new roles.
//        if (!empty($request['role_id'])) {
//            $this->assignRole($user, $request['role_id']);
//        }
//
//        //Assign new extra permissions.
//        if (!empty($request['extra_permissions_ids'])) {
//            $this->assignExtraPermissions($user, $request['extra_permissions_ids']);
//        }
//
//        return Response::success(new UserResource($user->fresh()));
//    }

    /**
     * export users in file
     * @return \Symfony\Component\HttpFoundation\BinaryFileResponse
     */
    public function export(Request $request)
    {
        return Excel::download(new UsersExport($request['year']), 'pilgrims.xlsx');
    }

    /**
     * import file from file.
     * @return \Illuminate\Http\RedirectResponse
     */
    public function import()
    {
        try {
            Excel::import(new UsersImport, request()->file('file'));

            return Response::success([]);

        } catch (ValidationException $e) {

            return Response::clientError([$e->failures()]);
        }
    }

    /**
     * Assign Role.
     * Assign Permissions related to the role.
     * @param $user
     * @param $role_id
     * @return void
     */
    public function assignRole($user, $role_id): void
    {
        $user->syncRoles($role_id);

        $role = Role::find($role_id);

        $user->syncPermissions($role->getPermissionNames());
    }

    /**
     * Assign Extra Permissions.
     * @param User $user
     * @param $extra_permissions_ids
     * @return void
     */
    public function assignExtraPermissions(User $user, $extra_permissions_ids): void
    {
        $user->givePermissionTo($extra_permissions_ids);
    }

    /**
     * @param User $user
     * @return void
     * @throws FileDoesNotExist
     * @throws FileIsTooBig
     */
    public function syncPhoto(User $user): void
    {
        $this->deleteOldPhoto($user);

        $this->addNewPhoto($user);
    }

    /**
     * @param User $user
     * @return void
     */
    public function deleteOldPhoto(User $user): void
    {
        $old_photo = $user->getMedia()->first();
        if ($old_photo) $old_photo->delete();
    }

    /**
     * @param User $user
     * @return void
     * @throws FileDoesNotExist
     * @throws FileIsTooBig
     */
    public function addNewPhoto(User $user): void
    {
        $user->addMediaFromRequest('photo')->toMediaCollection();
    }

    /**
     * @param User $user
     * @return void
     */
    public function revokeOldRolesAndPermissions(User $user): void
    {
        $user->syncRoles([]);
        $user->syncPermissions([]);
    }
}
