<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Constants\SharedConstant;
use App\Http\Constants\UserConstant;
use App\Http\Controllers\Controller;
use App\Models\Camp;
use App\Models\CampHall;
use App\Models\HallBed;
use App\Models\Location;
use App\Models\User;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index()
    {
        $users_count = User::all()->count();
        $admins_count = User::whereStatus(UserConstant::STATUSES['ACTIVE'])->whereType(UserConstant::TYPES['ADMIN'])->count();
        $pilgrims_count = User::whereStatus(UserConstant::STATUSES['ACTIVE'])->whereType(UserConstant::TYPES['PILGRIM'])->count();
        $supervisor_count = User::whereStatus(UserConstant::STATUSES['ACTIVE'])->whereType(UserConstant::TYPES['SUPERVISOR'])->count();
        $camps = Camp::all()->count();
        $halls = CampHall::all()->count();
        $all_beds = HallBed::all()->count();
        $un_assigned_beds = HallBed::whereStatus(SharedConstant::STATUSES['AVAILABLE'])->doesntHave('housing')->count();
        $assigned_beds = HallBed::whereStatus(SharedConstant::STATUSES['NOT_AVAILABLE'])->count();
        $locations = Location::all()->count();

        return view('dashboard', compact('users_count', 'admins_count', 'pilgrims_count', 'supervisor_count', 'camps', 'halls', 'all_beds', 'un_assigned_beds','assigned_beds', 'locations'));
    }
}
