<?php

namespace App\Http\Controllers\Dashboard\Role;

use App\Http\Controllers\Controller;
use App\Http\Requests\Role\CreateRequest;
use App\Http\Requests\Role\UpdateRequest;
use App\Http\Requests\User\DeleteRequest;
use Illuminate\Support\Facades\Response;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class RoleController extends Controller
{
    public function __construct()
    {
        $this->middleware(['role_or_permission:super-admin|create-roles'])->only('store');
        $this->middleware(['role_or_permission:super-admin|show-roles'])->only('show');
        $this->middleware(['role_or_permission:super-admin|update-roles'])->only('update');
        $this->middleware(['role_or_permission:super-admin|list-roles'])->only('list');
        $this->middleware(['role_or_permission:super-admin|delete-roles'])->only('delete');
    }

    private const  PER_PAGE = 15;

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $roles = Role::with('permissions')->get();

        $permissions = Permission::all()->groupBy('module');

        return view('roles.index', compact('roles', 'permissions'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param CreateRequest $request
     * @return \Illuminate\Http\Response
     */
    public function store(CreateRequest $request)
    {
        $role = Role::create([
            'name' => \Str::slug($request->name_ar)
        ] + $request->validated());

        $role->syncPermissions($request->permissions ?? []);

        // return Response::success($role);

        return redirect()->route('roles.index')->with('success', 'تم الإضافة');
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $role = Role::findOrFail($id);

        $role->permissions;

        return Response::success($role);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param UpdateRequest $request
     * @param Role $role
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(UpdateRequest $request, Role $role)
    {
        $role->update($request->validated());

        $role->syncPermissions($request->permissions);

        return redirect()->route('roles.index')->with('success', 'تم التعديل');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DeleteRequest $request
     * @param Role $role
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy(DeleteRequest $request, $id)
    {
        Role::find($id)->delete();

        return redirect()->route('roles.index')->with('success', 'تم الحذف');
    }
}
