<?php

namespace App\Http\Middleware;

use App\Http\Constants\LanguageConstant;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Symfony\Component\HttpFoundation\Response as Status;

class DetectLanguage
{
    /**
     * Handle an incoming request.
     *
     * @param \Illuminate\Http\Request $request
     * @param \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse) $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if (request()->is('api*')) {

            if ($request->header(LanguageConstant::LANGUAGE_REQUEST_HEADER) && !in_array($request->header(LanguageConstant::LANGUAGE_REQUEST_HEADER), LanguageConstant::LOCALES)) {

                return Response::clientError('Invalid Language.', Status::HTTP_BAD_REQUEST);

            } else if (!$request->header(LanguageConstant::LANGUAGE_REQUEST_HEADER)) {

                return Response::clientError('Language Absent.', Status::HTTP_BAD_REQUEST);

            } else {

                app()->setLocale($request->header(LanguageConstant::LANGUAGE_REQUEST_HEADER));
            }
        }
    }
}
