<?php

namespace App\Http\Requests\Housing;

use App\Http\Controllers\Dashboard\Housing\HousingController;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Redirect;

class CreateRequest extends FormRequest
{
    /**
     * override failedValidation method.
     * @param Validator $validator
     * @return RedirectResponse|void
     */
    protected function failedValidation(Validator $validator)
    {
        if ($validator->fails()) {
            $errors = $validator->errors();
            return Redirect::back()->withErrors($errors);
        }
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [];
    }

    /**
     * @param \Illuminate\Validation\Validator $validator
     * @return void
     */
    public function withValidator(Validator $validator)
    {

        $errors = [];

        $validator->after(
            function ($validator) use ($errors) {
                $pilgrims_count = HousingController::getUnAssignedPilgrimsIds()->count();
                $beds_count = HousingController::getUnAssignedBedsIds()->count();

                //* validate case of pilgrims count bigger than beds count
//                if ($pilgrims_count > $beds_count) {
//                    $errors[] = 'لايمكن تنفيذ هذه العمليه حيث ان عدد الحجاج  (' . $pilgrims_count . ') اكبر من عدد الاسرة المتاحة (' . $beds_count . ') فضلا قم باضافة المزيد من الأسِرَّة';
//                }
                //* validate case of current pilgrims already assigned
                if ($pilgrims_count == 0) {
                    $errors[] = 'تم تسكين جميع الحجاج من قبل!';
                }
                foreach ($errors as $error) {
                    $validator->errors()->add('', $error);
                }
            }
        );
    }
}
