<?php

namespace App\Models;

use App\Http\Constants\SharedConstant;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CampHall extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'camp_id',
        'status',
        'beds_count',
    ];

    /**
     * get a relation.
     */
    public function camp()
    {
        return $this->belongsTo(Camp::Class);
    }

    /**
     * get a relation.
     */
    public function beds()
    {
        return $this->hasMany(HallBed::Class, 'hall_id', 'id')->where('status', SharedConstant::STATUSES['AVAILABLE']);
    }
}
