<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HallBed extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'hall_id',
        'status',
    ];

    /**
     * get a relation.
     */
    public function hall()
    {
        return $this->belongsTo(CampHall::Class);
    }

    /**
     * get a relation.
     */
    public function housing()
    {
        return $this->hasOne(UserHousing::Class,'bed_id','id');
    }
}
