<?php

namespace Database\Seeders;

use App\Models\Ritual;
use Illuminate\Database\Seeder;

class RitualsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Ritual::create([
            'title' => 'الإحرام',
            'description' => 'الإحرام هو الركن الأول من أركان الحج،
             وهو نية الدخول في النسك مقرونا بعمل من أعمال الحج كالتلبية،
             وهو واجب من واجبات الإحرام بمعنى أن على من تركه فدية،
             إما أن يذبح شاة،
             أو يصوم ثلاثة أيام،
             أو يطعم ستة مساكين.
             إذا وصل المسلم إلى الميقات وأراد أن يحرم فيستحب له أن يقص أظفاره ويزيل شعر العانة،
             وأن يغتسل ويتوضأ.
             ثم يلبس بعد ذلك ملابس الإحرام،
             بالنسبة للرجل فيلبس إزار ورداء أبيضين طاهرين،
             أما المرأة فتلبس ما تشاء من اللباس الساتر دون أن تتقيد بلون محدد،
             لكن تجتنب في إحرامها لبس النقاب والقفازين.
             بعد ذلك يصلى الحاج ركعتي الإحرام،
             ثم ينوي بعد ذلك الحج بقلبه أو بلسانه،
             فأما الحاج المتمتع فيقول: «لبيك بعمرة» لإنه سيقوم بأداء مناسك العمرة أولا قبل الحج،
             أما الحاج المقرن فيقول: «لبيك بحج وعمرة»،
             أما الحاج المفرد فيقول: «لبيك بحج».
             محظورات الإحرام يقصد بها الأمور التي يمنع المحرم من فعلها بسبب إحرامه،
             وتنقسم المحظورات إلى محظورات مشتركة بين الرجال والنساء،
             ومحظورات خاصة بالنساء وأخرى بالرجال،
             أما المحظورات المشتركة فهي إزالة الشعر، تقليم الأظافر، الجماع أو مباشرة النساء لشهوة، التطيب أي وضع العطر في البدن أو في ثياب الإحرام، قتل الصيد البري كالأرانب والغزلان وخلافه، وعقد الزواج.
             أما المحظورات الخاصة بالرجال فهي لبس الملابس المخيطة، وهو أن يلبس الثياب ونحوها مما هو مفصل على هيئة البدن كالقميص أو البنطال، كما يحرم عليه إنزال المني باستنماء أو جماع، وتغطية الرأس بملاصق، كالطاقية وما شابهها.
             أما المحظورات الخاصة بالنساء فهي لبس القفازين أو النقاب.
             فإن فعل المحرم المحظور جاهلا أو ناسيا أو مكرها فلا إثم عليه ولا فدية،
             وإن فعل المحرم المحظور لحاجة إليه فلا إثم عليه ولكن عليه فدية.',
            'order' => 1,
            'conditions' => json_encode([
                'الإسلام',
                'النية'
            ])
        ])->steps()->createMany([
            [
                'title' => 'النية',
                'description' => 'يُستحَبّ للمحرِم أن يذكُر نُسكه؛ فيقول إن كان مُعتمراً: "لبّيك عمرةً"، ويقول إن كان مُنفرداً: "لبّيك حجاً"، ويقول إن كان قَارناً: "لبّيك عمرةً وحجّا"، وإن كان مُتمتّعاً يقول: "لبّيك عمرةً"، ويدعو الحاجّ قائلاً: "اللهمّ هذه حجّةً لا رياء فيها ولا سُمعةً".',
                'order' => 1
            ],
            [
                'title' => 'الإغتسال',
                'description' => 'يُستحَبّ للرجل عند إحرامه للحجّ أو للعُمرة أن يغتسل، ويتنظّف، ويُعطّر بَدنه، ولا يُعطّر ثوبه، وأن يكتسيَ بإزارٍ ورداءٍ أبيضَين نظيفَين، وأن يتجرّد تماماً من المَخيط، ثمّ يرتدي نعلَيْه. وأمّا للمرأة فإنّه يُستحَبّ لها الاغتسال إن أرادت الإحرام، حتى وإن كانت على حيضٍ أو نفاسٍ، ثمّ ترتدي ما شاءت من الملابس الساترة مُتجنِّبةً لباس الشُّهرة واللباس الضيّق، وتحذرَ من التشبُّه بلباس غير المسلمين، ولا ترتدي النِّقاب، ولا القفّازات.',
                'order' => 2
            ],
            [
                'title' => 'الإحرام بعد الصلاة',
                'description' => 'يُستحَبّ للمُحرِم أن يُحرِم بعد الصلاة المفروضة، وليس للإحرام صلاةٌ خاصّةٌ به، فلا حرج عليه أن يُحرِم بعد ركعتَي سُنّة الوضوء، أو ركعتَي تحيّة المسجد، أو بعد صلاة الضحى، وعليه أن يستحضر النيّة في قلبه للدخول في النُّسك؛ سواء كان حجّاً، أو عمرةً، ويُستحَبّ إحرامه وإهلاله بعد الصلاة في المسجد.',
                'order' => 3
            ]
        ]);
    }
}
