@extends('layouts.main')


@section('content')
    <!--begin::Content wrapper-->
    <div class="d-flex flex-column flex-column-fluid">
        <!--begin::Toolbar-->
        <div id="kt_app_toolbar" class="app-toolbar py-3 py-lg-6">
            <!--begin::Toolbar container-->
            <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex flex-stack">
                <!--begin::Page title-->
                <div class="page-title d-flex flex-column justify-content-center flex-wrap me-3">
                    <!--begin::Title-->
                    <h1 class="page-heading d-flex text-dark fw-bold fs-3 flex-column justify-content-center my-0">
                        تسكين الحجاج</h1>
                    <!--end::Title-->
                    <!--begin::Breadcrumb-->
                    <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0 pt-1">
                        <!--begin::Item-->
                        <li class="breadcrumb-item text-muted">
                            <a href="#" class="text-muted text-hover-primary">الرئيسية</a>
                        </li>
                        <!--end::Item-->
                        <!--begin::Item-->
                        <li class="breadcrumb-item">
                            <span class="bullet bg-gray-400 w-5px h-2px"></span>
                        </li>
                        <!--end::Item-->
                        <!--begin::Item-->
                        <li class="breadcrumb-item text-muted">تسكين الحجاج</li>
                        <!--end::Item-->
                    </ul>
                    <!--end::Breadcrumb-->
                </div>
                <!--end::Page title-->
            </div>
            <!--end::Toolbar container-->
        </div>
        <!--end::Toolbar-->
        <div class="row">

            <div class="col-md-4" style="    margin-right: 26px;
    margin-bottom: 21px;
    display: inline-grid;
}">
                <span class="col-md-4"> عدد الحجاج الكلي : {{$pilgrims->count()}}</span>
                <span class="col-md-4"> عدد الحجاج غير المسكنين : {{$unAssignedPilgrimsCount}}</span>
                <span class="col-md-4"> عدد الحجاج المسكنين : {{$assignedPilgrimsCount}}</span>
            </div>
            <div class="col-md-4" style="    margin-right: 26px;
    margin-bottom: 21px;
    display: inline-grid;
}">
                <span class="col-md-4"> عدد الأسِرَّة الكلي : {{$allBeds}}</span>
                <span class="col-md-4"> عدد الأسِرَّة الشاغرة : {{$beds->count()}}</span>
                <span class="col-md-4"> عدد الأسِرَّة المسكنة : {{$assignedBedsCount}}</span>
            </div>
        </div>

        @include('layouts.partials.alerts')
        <!--begin::Content-->
        <div id="kt_app_content" class="app-content flex-column-fluid">
            <!--begin::Content container-->
            <div id="kt_app_content_container" class="app-container container-fluid">
                <!--begin::Basic info-->
                <div class="card mb-5 mb-xl-10">
                    <!--begin::Card header-->
                    <div class="card-header border-0 cursor-pointer" role="button" data-bs-toggle="collapse"
                         data-bs-target="#kt_account_profile_details" aria-expanded="true"
                         aria-controls="kt_account_profile_details">
                        <!--begin::Card title-->
                        <div class="card-title m-0">
                            <h3 class="fw-bold m-0">تسكين جماعي</h3>
                        </div>
                        <div class="card-toolbar">
                            {!! Form::open(['url' => route('user-housings.store') ,'class' => 'form', 'method' => 'POST']) !!}
                            <button type="submit" class="btn btn-sm btn-primary"
                                    onclick="return confirm('سيتم تسكين الحجاج بشكل عشوائي ؟')">تسكين
                                عشوائي
                            </button>
                            {!! Form::close() !!}
                        </div>

                        <div class="card-toolbar">
                            {!! Form::open(['url' => route('housing.reset') ,'class' => 'form', 'method' => 'POST']) !!}
                            <button type="submit" class="btn btn-sm btn-primary"
                                    onclick="return confirm('سيتم تفريغ جميع الأسِرَّة المشغولة ؟')">تفريغ الأسِرَّة

                            </button>
                            {!! Form::close() !!}
                        </div>


                        <!--end::Card title-->
                    </div>


                    <!--begin::Card header-->
                    <!--begin::Content-->
                    <div id="kt_account_settings_profile_details" class="collapse show">
                        <!--begin::Form-->
                        {!! Form::open(['url' => route('housing.assign') ,'class' => 'form', 'method' => 'POST']) !!}
                        <form id="kt_account_profile_details_form" class="form">
                            <!--begin::Card body-->
                            <div class="card-body border-top p-9">
                                <div class="card-title m-0">
                                    <h3 class="fw-bold m-0">تسكين فردي</h3><br>
                                </div>
                                <!--begin::Input group-->
                                <div class="row mb-6">
                                    <!--begin::Label-->
                                    <label class="col-lg-4 col-form-label fw-semibold fs-6">
                                        <span class="">الحاج</span>
                                    </label>
                                    <!--end::Label-->
                                    <!--begin::Col-->
                                    <div class="col-lg-8 fv-row">
                                        <select required id="pilgrim_id" name="pilgrim_id" aria-label="اختر..."
                                                data-control="select2"
                                                data-placeholder="اختر..."
                                                class="form-select form-select-solid form-select-lg fw-semibold">
                                            @foreach($pilgrims as $pilgrim)
                                                <option></option>
                                                <option value="{{ $pilgrim->id }}">
                                                    {{$pilgrim->first_name .' '. $pilgrim->last_name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <!--end::Col-->
                                </div>
                                <!--end::Input group-->
                                <!--begin::Input group-->
                                <div class="row mb-6">
                                    <!--begin::Label-->
                                    <label class="col-lg-4 col-form-label fw-semibold fs-6">
                                        <span class="">المخيم</span>
                                    </label>
                                    <!--end::Label-->
                                    <!--begin::Col-->
                                    <div class="col-lg-8 fv-row">
                                        <select required id="camp_id" name="camp_id" aria-label="اختر..."
                                                data-control="select2"
                                                data-placeholder="اختر..."
                                                class="form-select form-select-solid form-select-lg fw-semibold">
                                        </select>
                                    </div>
                                    <!--end::Col-->
                                </div>
                                <!--end::Input group-->
                                <!--begin::Input group-->
                                <div class="row mb-6">
                                    <!--begin::Label-->
                                    <label class="col-lg-4 col-form-label fw-semibold fs-6">
                                        <span class="">القاعة</span>
                                    </label>
                                    <!--end::Label-->
                                    <!--begin::Col-->
                                    <div class="col-lg-8 fv-row">
                                        <select required id="hall_id" name="hall_id" aria-label="اختر..."
                                                data-control="select2"
                                                data-placeholder="اختر..."
                                                class="form-select form-select-solid form-select-lg fw-semibold">
                                        </select>

                                    </div>
                                    <!--end::Col-->
                                </div>
                                <!--end::Input group-->
                                <!--begin::Input group-->
                                <div class="row mb-6">
                                    <!--begin::Label-->
                                    <label class="col-lg-4 col-form-label fw-semibold fs-6">
                                        <span class="">السرير</span>
                                    </label>
                                    <!--end::Label-->
                                    <!--begin::Col-->
                                    <div class="col-lg-8 fv-row">
                                        <select required id="bed_id" name="bed_id" aria-label="اختر..."
                                                data-control="select2"
                                                data-placeholder="اختر..."
                                                class="form-select form-select-solid form-select-lg fw-semibold">
                                        </select>
                                    </div>
                                    <!--end::Col-->
                                </div>
                                <!--end::Input group-->
                            </div>
                            <!--end::Card body-->

                            <!--begin::Actions-->
                            <div class="card-footer d-flex justify-content-end py-6 px-9">
                                <button type="submit" class="btn btn-primary"
                                        id="kt_account_profile_details_submit"> تسكين الحاج
                                </button>
                            </div>
                            <!--end::Actions-->
                            <!--end::Form-->
                        {!! Form::close() !!}
                    </div>
                    <!--end::Content-->

                    <!--begin::Content-->
                    <div id="kt_account_settings_profile_details" class="collapse show">
                        <!--begin::Form-->
                        {!! Form::open(['url' => route('housing.un-assign') ,'class' => 'form', 'method' => 'POST']) !!}
                        <form id="kt_account_profile_details_form2" class="form">
                            <!--begin::Card body-->
                            <div class="card-body border-top p-9">
                                <div class="card-title m-0">
                                    <h3 class="fw-bold m-0">حذف تسكين فردي</h3><br>
                                </div>
                                <!--begin::Input group-->
                                <div class="row mb-6">
                                    <!--begin::Label-->
                                    <label class="col-lg-4 col-form-label fw-semibold fs-6">
                                        <span class="">الحاج</span>
                                    </label>
                                    <!--end::Label-->
                                    <!--begin::Col-->
                                    <div class="col-lg-8 fv-row">
                                        <select required id="un_assigned_pilgrim_id" name="un_assigned_pilgrim_id"
                                                aria-label="اختر..."
                                                data-control="select2"
                                                data-placeholder="اختر..."
                                                class="form-select form-select-solid form-select-lg fw-semibold">
                                            @foreach($pilgrims as $pilgrim)
                                                <option></option>
                                                <option value="{{ $pilgrim->id }}">
                                                    {{$pilgrim->first_name .' '. $pilgrim->last_name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <!--end::Col-->
                                </div>
                                <!--end::Input group-->
                            </div>
                            <!--end::Card body-->

                            <!--begin::Actions-->
                            <div class="card-footer d-flex justify-content-end py-6 px-9">
                                <button type="submit" class="btn btn-danger"
                                        onclick="return confirm('سيتم حذف التسكين لهذا الحاج ؟')"
                                        id="kt_account_profile_details_submit"> حذف التسكين
                                </button>
                            </div>
                            <!--end::Actions-->
                            <!--end::Form-->
                        {!! Form::close() !!}
                    </div>
                    <!--end::Content-->
                </div>
            </div>
            <!--end::Basic info-->
        </div>
        <!--end::Content container-->
    </div>
    <!--end::Content-->

    </div>
    <!--end::Content wrapper-->
@endsection


<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
    $(document).ready(function () {
        /**
         * Set Pilgrim Data.
         */
        $('#pilgrim_id').on('change', function () {
            let pilgrim_id = this.value;
            $("#camp_id").html('');
            $("#hall_id").html('');
            $("#bed_id").html('');
            $.ajax({
                url: '{{url('fetch-pilgrim-data')}}/' + pilgrim_id,
                type: 'GET',
                dataType: 'json',
                success: function (result) {
                    let pilgrim = result;
                    console.log(pilgrim)
                    $.ajax({
                        url: '{{url('fetch-camps')}}',
                        type: 'POST',
                        dataType: 'json',
                        data: {
                            _token: '{{csrf_token()}}'
                        },
                        success: function (result) {
                            let camps = result.camps;
                            $("#camp_id").append('<option value="' + pilgrim.camp_id + '">' + pilgrim.camp_name + '</option>');
                            $.each(camps, function (key, camp) {
                                if (camp.id != pilgrim.camp_id) {
                                    $("#camp_id").append('<option value="' + camp
                                        .id + '">' + camp.name + '</option>');
                                }
                                $.each(camp.halls, function (key, hall) {
                                    if (key == 0) $("#hall_id").append('<option value="' + pilgrim.hall_id + '">' + pilgrim.hall_name + '</option>');
                                    if (hall.id != pilgrim.hall_id) {
                                        $("#hall_id").append('<option value="' + hall
                                            .id + '">' + hall.name + '</option>');
                                    }
                                    $.each(hall.beds, function (key, bed) {
                                        if (key == 0) $("#bed_id").append('<option value="' + pilgrim.bed_id + '">' + pilgrim.bed_name + '</option>');
                                        if (bed.id != pilgrim.bed_id) {
                                            $("#bed_id").append('<option value="' + bed
                                                .id + '">' + bed.name + '</option>');
                                        }
                                    });

                                });
                            });
                        }
                    });
                }
            });
        });

        /**
         * Set Selecting Camp Data.
         */
        $('#camp_id').on('change', function () {
            let camp_id = this.value;
            $("#hall_id").html('');
            $.ajax({
                url: "{{url('fetch-camp-halls')}}",
                type: "POST",
                data: {
                    camp_id: camp_id,
                    _token: '{{csrf_token()}}'
                },
                dataType: 'json',
                success: function (result) {
                    $('#hall_id').html('<option value=""></option>');
                    $.each(result.halls, function (key, value) {
                        $("#hall_id").append('<option value="' + value
                            .id + '">' + value.name + '</option>');
                    });
                    $('#bed_id').html('<option value=""></option>');
                }
            });
        });

        /**
         * Set Selecting Hall Data.
         */
        $('#hall_id').on('change', function () {
            let hall_id = this.value;
            $("#bed_id").html('');
            $.ajax({
                url: "{{url('fetch-hall-beds')}}",
                type: "POST",
                data: {
                    hall_id: hall_id,
                    _token: '{{csrf_token()}}'
                },
                dataType: 'json',
                success: function (result) {
                    $('#bed_id').html('<option value=""></option>');
                    $.each(result.beds, function (key, value) {
                        $("#bed_id").append('<option value="' + value
                            .id + '">' + value.name + '</option>');
                    });
                }
            });
        });
    });
</script>
