@extends('layouts.main')


@section('content')
    <!--begin::Content wrapper-->
    <div class="d-flex flex-column flex-column-fluid">

        <!--begin::Toolbar-->
        <div id="kt_app_toolbar" class="app-toolbar py-3 py-lg-6">
            <!--begin::Toolbar container-->
            <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex flex-stack">
                <!--begin::Page title-->
                <div class="page-title d-flex flex-column justify-content-center flex-wrap me-3">
                    <!--begin::Title-->
                    <h1 class="page-heading d-flex text-dark fw-bold fs-3 flex-column justify-content-center my-0">
                        الإعدادات</h1>
                    <!--end::Title-->
                    <!--begin::Breadcrumb-->
                    <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0 pt-1">
                        <!--begin::Item-->
                        <li class="breadcrumb-item text-muted">
                            <a href="{{ route('home') }}" class="text-muted text-hover-primary">الرئيسية</a>
                        </li>
                        <!--end::Item-->
                        <!--begin::Item-->
                        <li class="breadcrumb-item">
                            <span class="bullet bg-gray-400 w-5px h-2px"></span>
                        </li>
                        <!--end::Item-->
                        <!--begin::Item-->
                        <li class="breadcrumb-item text-muted">الإعدادات</li>
                        <!--end::Item-->
                    </ul>
                    <!--end::Breadcrumb-->

                </div>

                <!--end::Page title-->
            </div>
            <!--end::Toolbar container-->
        </div>
        <!--end::Toolbar-->

        <!--begin::Content-->
        <div id="kt_app_content" class="app-content flex-column-fluid">
            @include('layouts.partials.alerts')

            <!--begin::Content container-->
            <div class="card mb-5 mb-xl-8">
                <!--begin::Header-->
                <div class="card-header border-0 pt-5">
                    <h3 class="card-title align-items-start flex-column" style="display:block;>
                        <a href="{{ route('settings.index') }}"> <span
                        class="card-label fw-bold fs-3 mb-1">الإعدادات</span></a>|
                    <a href="{{ route('settings.create') }}" class="btn btn-sm btn-light-primary">
                            <span class="svg-icon svg-icon-2">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <rect opacity="0.5" x="11.364" y="20.364" width="16" height="2" rx="1"
                                      transform="rotate(-90 11.364 20.364)" fill="currentColor"/>
                                <rect x="4.36396" y="11.364" width="16" height="2" rx="1" fill="currentColor"/>
                            </svg>
                        </span>
                        <!--end::Svg Icon-->إعداد جديد</a>
                    </h3>
                    <div></div>
                </div>
                <!--end::Header-->
                <!--begin::Body-->
                <div class="card-body py-3">
                    <!--begin::Table container-->
                    <div class="table-responsive">
                        <!--begin::Table-->
                        <table id="settings-table" class="table align-middle gs-0 gy-4">
                            <!--begin::Table head-->
                            <thead>
                            <tr class="fw-bold text-muted bg-light">
                                <th class="ps-4 min-w-200px rounded-start">الإسم</th>
                                <th class="min-w-125px">القيمة</th>
                                <th class="min-w-200px text-end rounded-end"></th>
                            </tr>
                            </thead>
                            <!--end::Table head-->
                            <!--begin::Table body-->
                            <tbody>
                            @foreach($settings as $setting)
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="symbol symbol-50px me-5">
                                                {{-- <img src="assets/media/stock/600x400/img-26.jpg" class="" alt=""/>--}}
                                            </div>
                                            <div class="d-flex justify-content-start flex-column">
                                                <a href="#"
                                                   class="text-dark fw-bold text-hover-primary mb-1 fs-6">{{$setting->name}}</a>
                                                {{-- <span class="text-muted fw-semibold text-muted d-block fs-7">HTML, JS, ReactJS</span>--}}
                                            </div>
                                        </div>
                                    </td>
                                    <td style="max-width: 250px !important;display: revert;">
                                        <a href="#"
                                           class="text-dark fw-bold text-hover-primary d-block mb-1 fs-6">{{$setting->value}}</a>
                                    </td>
                                    <td class="text-end" style="display: flex;justify-content: center;">
                                        <a href="{{ route('settings.show',$setting->id ) }}"
                                           class="btn btn-primary btn-sm align-self-center">عرض</a>

                                        {!! Form::open(['url' => route('settings.destroy', $setting->id), 'method' => 'DELETE', 'class' => 'd-inline']) !!}
                                        <button style="margin-right: 5px" type="submit"
                                                onclick="return confirm('هل أنت متأكد من الحذف ؟')"
                                                class="btn btn-danger btn-sm align-self-center">حذف
                                        </button>

                                        {!! Form::close() !!}

                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                            <!--end::Table body-->
                        </table>
                        <!--end::Table-->
                        <!--begin::Pagination-->
                        <div class="d-flex flex-stack flex-wrap pt-10">
                            <div class="fs-6 fw-semibold text-gray-700">Showing {{$settings->count()}}
                                of {{ $settings->total() }} Entries
                            </div>
                            <!--begin::Pages-->
                            {{ $settings->links() }}
                            <!--end::Pages-->
                        </div>
                        <!--end::Pagination-->
                    </div>
                    <!--end::Table container-->
                </div>
                <!--begin::Body-->
            </div>

            <!--end::Header---->
            <!--begin::Actions-->
            <div class="d-flex align-items-center gap-2 gap-lg-3">

            </div>
            <!--end::Actions-->
        </div>
        <!--end::Content container-->
    </div>
    <!--end::Content-->

    </div>
    <!--end::Content wrapper-->
@endsection
