<?php

use App\Http\Controllers\Api\V1\Auth\ChangePasswordController;
use App\Http\Controllers\Api\V1\Auth\LoginController;
use App\Http\Controllers\Api\V1\User\UserController;
use Illuminate\Support\Facades\Route;

Route::group(['prefix' => 'v1'], function () {

    /*
    |--------------------------------------------------------------------------
    | Auth Routes
    |--------------------------------------------------------------------------
    */
    Route::group(['prefix' => 'auth'], function () {

        Route::post('login', [LoginController::class, 'login']);

        Route::patch('change-password', [ChangePasswordController::class, 'changePassword']);

    });

    /*
    |--------------------------------------------------------------------------
    | User Routes
    |--------------------------------------------------------------------------
    |
    */
    Route::group(['middleware' => 'auth.jwt'], function () {

        Route::apiResources(['users' => UserController::class]);
//
//        Route::get('users-export', [UserController::class, 'export']);
//
//        Route::post('users-import', [UserController::class, 'import']);

    });


    /*
    |--------------------------------------------------------------------------
    | Resource Routes
    |--------------------------------------------------------------------------
    |
    */


    /*
    |--------------------------------------------------------------------------
    | Individual Routes
    |--------------------------------------------------------------------------
    |
    */


});
