<?php $__env->startSection('content'); ?>
    <!--begin::Content wrapper-->
    <div class="d-flex flex-column flex-column-fluid">

        <!--begin::Toolbar-->
        <div id="kt_app_toolbar" class="app-toolbar py-3 py-lg-6">
            <!--begin::Toolbar container-->
            <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex flex-stack">
                <!--begin::Page title-->
                <div class="page-title d-flex flex-column justify-content-center flex-wrap me-3">
                    <!--begin::Title-->
                    <h1 class="page-heading d-flex text-dark fw-bold fs-3 flex-column justify-content-center my-0">
                        المواقع</h1>
                    <!--end::Title-->
                    <!--begin::Breadcrumb-->
                    <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0 pt-1">
                        <!--begin::Item-->
                        <li class="breadcrumb-item text-muted">
                            <a href="<?php echo e(route('home')); ?>" class="text-muted text-hover-primary">الرئيسية</a>
                        </li>
                        <!--end::Item-->
                        <!--begin::Item-->
                        <li class="breadcrumb-item">
                            <span class="bullet bg-gray-400 w-5px h-2px"></span>
                        </li>
                        <!--end::Item-->
                        <!--begin::Item-->
                        <li class="breadcrumb-item text-muted">المواقع</li>
                        <!--end::Item-->
                    </ul>
                    <!--end::Breadcrumb-->

                </div>

                <!--end::Page title-->
            </div>
            <!--end::Toolbar container-->
        </div>
        <!--end::Toolbar-->

        <!--begin::Content-->
        <div id="kt_app_content" class="app-content flex-column-fluid">
            <?php echo $__env->make('layouts.partials.alerts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <!--begin::Content container-->
            <div class="card mb-5 mb-xl-8">
                <!--begin::Header-->
                <div class="card-header border-0 pt-5">
                    <h3 class="card-title align-items-start flex-column" style="display:block;>
                        <a href="<?php echo e(route('locations.index')); ?>"> <span
                                class="card-label fw-bold fs-3 mb-1">المواقع</span></a>|
                        <a href="<?php echo e(route('locations.create')); ?>" class="btn btn-sm btn-light-primary">
                            <span class="svg-icon svg-icon-2">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <rect opacity="0.5" x="11.364" y="20.364" width="16" height="2" rx="1"
                                      transform="rotate(-90 11.364 20.364)" fill="currentColor"/>
                                <rect x="4.36396" y="11.364" width="16" height="2" rx="1" fill="currentColor"/>
                            </svg>
                        </span>
                            <!--end::Svg Icon-->موقع جديد</a>
                    </h3>

                    <!--begin::Search-->
                    <?php echo Form::open(['url' => route('locations.index') ,'class' => 'form', 'method' => 'GET']); ?>

                    <div class="d-flex align-items-center position-relative my-1">
                        <!--begin::Svg Icon | path: icons/duotune/general/gen021.svg-->
                        <span class="svg-icon svg-icon-1 position-absolute ms-6">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <rect opacity="0.5" x="17.0365" y="15.1223" width="8.15546" height="2" rx="1"
                                      transform="rotate(45 17.0365 15.1223)" fill="currentColor"/>
                                <path
                                    d="M11 19C6.55556 19 3 15.4444 3 11C3 6.55556 6.55556 3 11 3C15.4444 3 19 6.55556 19 11C19 15.4444 15.4444 19 11 19ZM11 5C7.53333 5 5 7.53333 5 11C5 14.4667 7.53333 17 11 17C14.4667 17 17 14.4667 17 11C17 7.53333 14.4667 5 11 5Z"
                                    fill="currentColor"/>
                            </svg>
                        </span>
                        <!--end::Svg Icon-->
                        <input type="text" name="search" data-kt-customer-table-filter="search"
                               class="form-control form-control-solid w-250px ps-15" placeholder="الاسم, العنوان"/>
                    </div>
                    <?php echo Form::close(); ?>


                    <!--end::Search-->
                </div>
                <!--end::Header-->
                <!--begin::Body-->
                <div class="card-body py-3">
                    <!--begin::Table container-->
                    <div class="table-responsive">
                        <!--begin::Table-->
                        <table id="locations-table" class="table align-middle gs-0 gy-4">
                            <!--begin::Table head-->
                            <thead>
                            <tr class="fw-bold text-muted bg-light">
                                <th class="ps-4 min-w-200px rounded-start">الإسم</th>

                                <th class="min-w-125px">الأوامر</th>
                                <th class="min-w-2000px text-end rounded-end"></th>
                            </tr>
                            </thead>
                            <!--end::Table head-->
                            <!--begin::Table body-->
                            <tbody>
                            <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="symbol symbol-50px me-5">
                                                
                                            </div>
                                            <div class="d-flex justify-content-start flex-column">
                                                <a href="#"
                                                   class="text-dark fw-bold text-hover-primary mb-1 fs-6"><?php echo e($location->name); ?></a>
                                                
                                            </div>
                                        </div>
                                    </td>




                                    <td class="text-end" style="display: flex;justify-content: right;">
                                        <a href="<?php echo e(route('locations.show',$location->id )); ?>"
                                           class="btn btn-primary btn-sm align-self-center">عرض</a>

                                        <?php echo Form::open(['url' => route('locations.destroy', $location->id), 'method' => 'DELETE', 'class' => 'd-inline']); ?>

                                        <button style="margin-right: 5px" type="submit"
                                                onclick="return confirm('هل أنت متأكد من الحذف ؟')"
                                                class="btn btn-danger btn-sm align-self-center">حذف
                                        </button>

                                        <?php echo Form::close(); ?>


                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                            <!--end::Table body-->
                        </table>
                        <!--end::Table-->
                        <!--begin::Pagination-->
                        <div class="d-flex flex-stack flex-wrap pt-10">
                            <div class="fs-6 fw-semibold text-gray-700">Showing <?php echo e($locations->count()); ?>

                                of <?php echo e($locations->total()); ?> Entries
                            </div>
                            <!--begin::Pages-->
                            <?php echo e($locations->links()); ?>

                            <!--end::Pages-->
                        </div>
                        <!--end::Pagination-->
                    </div>
                    <!--end::Table container-->
                </div>
                <!--begin::Body-->
            </div>

            <!--end::Header---->
            <!--begin::Actions-->
            <div class="d-flex align-items-center gap-2 gap-lg-3">

            </div>
            <!--end::Actions-->
        </div>
        <!--end::Content container-->
    </div>
    <!--end::Content-->

    </div>
    <!--end::Content wrapper-->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/hajj/resources/views/locations/index.blade.php ENDPATH**/ ?>