<?php $__env->startPush('page-css'); ?>
    <!--begin::Vendor Stylesheets(used by this page)-->
    <link href="<?php echo e(asset('assets/plugins/custom/datatables/datatables.bundle.rtl.css')); ?>" rel="stylesheet"
          type="text/css"/>
    <!--end::Vendor Stylesheets-->
<?php $__env->stopPush(); ?>


<?php $__env->startSection('content'); ?>
    <!--begin::Content wrapper-->
    <div class="d-flex flex-column flex-column-fluid">

        <!--begin::Toolbar-->
        <div id="kt_app_toolbar" class="app-toolbar py-3 py-lg-6">
            <!--begin::Toolbar container-->
            <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex flex-stack">
                <!--begin::Page title-->
                <div class="page-title d-flex flex-column justify-content-center flex-wrap me-3">
                    <!--begin::Title-->
                    <h1 class="page-heading d-flex text-dark fw-bold fs-3 flex-column justify-content-center my-0">
                        الشعائر</h1>
                    <!--end::Title-->
                    <!--begin::Breadcrumb-->
                    <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0 pt-1">
                        <!--begin::Item-->
                        <li class="breadcrumb-item text-muted">
                            <a href="<?php echo e(route('home')); ?>" class="text-muted text-hover-primary">الرئيسية</a>
                        </li>
                        <!--end::Item-->
                        <!--begin::Item-->
                        <li class="breadcrumb-item">
                            <span class="bullet bg-gray-400 w-5px h-2px"></span>
                        </li>
                        <!--end::Item-->
                        <!--begin::Item-->
                        <li class="breadcrumb-item text-muted">الشعائر</li>
                        <!--end::Item-->
                    </ul>
                    <!--end::Breadcrumb-->

                </div>
                <!--end::Page title-->
            </div>
            <!--end::Toolbar container-->
        </div>
        <!--end::Toolbar-->

        <!--begin::Content-->
        <div id="kt_app_content" class="app-content flex-column-fluid">
            <!--begin::Content container-->
            <div id="kt_app_content_container" class="app-container container-xxl">
                <?php echo $__env->make('layouts.partials.alerts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <div class="card mb-5 mb-xl-8">
                    <!--begin::Header-->
                    <div class="card-header border-0 pt-5">
                        <h3 class="card-title align-items-start flex-column" style="display: block">
                            <span class="card-label fw-bold fs-3 mb-1">الشعائر</span>|
                            <a href="<?php echo e(route('rituals.create')); ?>" class="btn btn-sm btn-light-primary">
                            <span class="svg-icon svg-icon-2">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <rect opacity="0.5" x="11.364" y="20.364" width="16" height="2" rx="1"
                                          transform="rotate(-90 11.364 20.364)" fill="currentColor"/>
                                    <rect x="4.36396" y="11.364" width="16" height="2" rx="1" fill="currentColor"/>
                                </svg>
                            </span>
                                إضافة شعيرة</a>
                        </h3>
                        <div class="card-toolbar">
                            <!--begin::Actions-->
                            <div class="d-flex align-items-center gap-2 gap-lg-3">
                                <!--begin::Filter menu-->
                                <div class="m-0">
                                    <!--begin::Menu toggle-->
                                    <a href="#"
                                       class="btn btn-sm btn-flex bg-body btn-color-gray-700 btn-active-color-primary fw-bold"
                                       data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end">
                                        <!--begin::Svg Icon | path: icons/duotune/general/gen031.svg-->
                                        <span class="svg-icon svg-icon-6 svg-icon-muted me-1">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M19.0759 3H4.72777C3.95892 3 3.47768 3.83148 3.86067 4.49814L8.56967 12.6949C9.17923 13.7559 9.5 14.9582 9.5 16.1819V19.5072C9.5 20.2189 10.2223 20.7028 10.8805 20.432L13.8805 19.1977C14.2553 19.0435 14.5 18.6783 14.5 18.273V13.8372C14.5 12.8089 14.8171 11.8056 15.408 10.964L19.8943 4.57465C20.3596 3.912 19.8856 3 19.0759 3Z"
                                                fill="currentColor"/>
                                        </svg>
                                    </span>
                                        <!--end::Svg Icon-->تحديد خيارات العرض</a>
                                    <!--end::Menu toggle-->

                                    <!--begin::Menu 1-->
                                    <div class="menu menu-sub menu-sub-dropdown w-250px w-md-300px" data-kt-menu="true"
                                         id="kt_menu_631f0552f045e">
                                        <!--begin::Header-->
                                        <div class="px-7 py-5">
                                            <div class="fs-5 text-dark fw-bold">خيارات العرض</div>
                                        </div>

                                        <?php echo Form::open(['url' => route('rituals.index') ,'class' => 'form', 'method' => 'GET']); ?>


                                        <!--end::Header-->
                                        <!--begin::Menu separator-->
                                        <div class="separator border-gray-200"></div>
                                        <!--end::Menu separator-->
                                        <!--begin::Form-->
                                        <div class="px-7 py-5">
                                            <!--begin::Input group-->
                                            <div class="mb-10">
                                                <!--begin::Label-->
                                                <label class="form-label fw-semibold">الحالة:</label>
                                                <!--end::Label-->
                                                <!--begin::Input-->
                                                <div>
                                                    <select class="form-select form-select-solid" data-kt-select2="true"
                                                            name="status" data-placeholder="اختر"
                                                            data-dropdown-parent="#kt_menu_631f0552f045e"
                                                            data-allow-clear="true">
                                                        <option></option>
                                                        <option value="all">الكل</option>
                                                        <option value="1">نشط</option>
                                                        <option value="0">غير نشط</option>
                                                        <option value="2">موقوف</option>
                                                    </select>
                                                </div>
                                                <!--end::Input-->
                                                <!--begin::Input group-->
                                                <div class="mb-10">
                                                    <!--begin::Label-->
                                                    <label class="form-label fw-semibold">نوع المستخدم:</label>
                                                    <!--end::Label-->
                                                    <!--begin::Input-->
                                                    <div>
                                                        <select class="form-select form-select-solid" name="type"
                                                                data-kt-select2="true" data-placeholder="اختر"
                                                                data-dropdown-parent="#kt_menu_631f0552f045e"
                                                                data-allow-clear="true">
                                                            <option></option>
                                                            <option value="all">الكل</option>
                                                            <option value="2">أدمن</option>
                                                            <option value="1">مشرف</option>
                                                            <option value="0">حاج</option>
                                                        </select>
                                                    </div>
                                                    <!--end::Input-->

                                                </div>
                                                <!--end::Input group-->
                                                <!--begin::Actions-->
                                                <div class="d-flex justify-content-end">
                                                    <a href="<?php echo e(route('rituals.index')); ?>">
                                                        <button type="reset"
                                                                class="btn btn-sm btn-light btn-active-light-primary me-2"
                                                                data-kt-menu-dismiss="true">إلغاء
                                                        </button>
                                                    </a>
                                                    <button type="submit" class="btn btn-sm btn-primary"
                                                            data-kt-menu-dismiss="true">عرض البيانات
                                                    </button>
                                                    <?php echo Form::close(); ?>


                                                </div>
                                                <!--end::Actions-->
                                            </div>
                                            <!--end::Form-->
                                        </div>
                                        <!--end::Menu 1-->
                                    </div>

                                    <!--end::Menu 1-->
                                </div>
                                <!--end::Actions-->
                            </div>
                        </div>
                    </div>
                    <!--end::Header-->
                    <!--begin::Body-->
                    <div class="card-body py-3">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('list-rituals')): ?>
                            <!--begin::Table container-->
                            <div class="table-responsive">
                                <!--begin::Table-->
                                <table id="rituals-table" class="table align-middle gs-0 gy-4">
                                    <!--begin::Table head-->
                                    <thead>
                                    <tr class="fw-bold text-muted bg-light">
                                        <th class="ps-4 min-w-200px rounded-start">العنوان</th>
                                        <th class="min-w-125px">الترتيب</th>
                                        <th class="min-w-125px">الأوامر</th>
                                        <th class="min-w-2000px text-end rounded-end"></th>
                                    </tr>
                                    </thead>
                                    <!--end::Table head-->
                                    <!--begin::Table body-->
                                    <tbody>
                                    <?php $__currentLoopData = $rituals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ritual): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($ritual->title); ?></td>
                                            <td><?php echo e($ritual->order); ?></td>

                                            <td class="text-end" style="display: flex;justify-content: right;">
                                                <a href="<?php echo e(route('rituals.show',$ritual->id )); ?>"
                                                   class="btn btn-primary btn-sm align-self-center">عرض</a>

                                                <?php echo Form::open(['url' => route('rituals.destroy', $ritual->id), 'method' => 'DELETE']); ?>

                                                <button style="margin-right: 5px" type="submit"
                                                        onclick="return confirm('هل أنت متأكد من الحذف ؟')"
                                                        class="btn btn-danger btn-sm align-self-center">حذف
                                                </button>

                                                <?php echo Form::close(); ?>


                                            </td>
                                            
                                            

                                            
                                            
                                            
                                            

                                            
                                            
                                            

                                            
                                            
                                            
                                            
                                            

                                            

                                            
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                    <!--end::Table body-->
                                </table>
                                <!--end::Table-->
                            </div>
                            <!--end::Table container-->
                        <?php endif; ?>
                    </div>
                    <!--begin::Body-->
                </div>
            </div>

        </div>
        <!--end::Content container-->
    </div>
    <!--end::Content-->

    </div>
    <!--end::Content wrapper-->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('page-scripts'); ?>
    <!--begin::Vendors Javascript(used by this page)-->
    <script src="<?php echo e(asset('assets/plugins/custom/datatables/datatables.bundle.js')); ?>"></script>
    <!--end::Vendors Javascript-->
    <script>
        $('#rituals-table').DataTable();

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/hajj/resources/views/rituals/index.blade.php ENDPATH**/ ?>